<!-- business information here -->
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!-- <link rel="stylesheet" href="style.css"> -->
    <title>Receipt-<?php echo e($receipt_details->invoice_no, false); ?></title>
    <?php
        $locale = 'bn';
        $f8 = $locale == 'en' ? '11px' : '7px';
        $headings = $locale == 'en' ? '16px' : '12px';
        $subHeadings = $locale == 'en' ? '14px' : '14px';
        $th = $locale == 'en' ? '12px' : '11px';
        $print = $locale == 'en' ? '11px' : '10px';
        $textboxInfo = $locale == 'en' ? '12px' : '12px';
    ?>
	
    <style type="text/css">
        .f-8 {
            font-size: <?php echo e($f8, false); ?> !important;
        }
        body {
            color: #000000;
        }
        @media print {
            * {
                font-size: <?php echo e($print, false); ?>;
                font-family: 'Times New Roman';
                word-break: break-all;
            }
            .f-8 {
                font-size: <?php echo e($f8, false); ?> !important;
            }
            .headings {
                font-size: <?php echo e($headings, false); ?>;
                font-weight: 600;
                text-transform: uppercase;
                white-space: nowrap;
            }
            .sub-headings {
                font-size: <?php echo e($subHeadings, false); ?> !important;
                font-weight: 600 !important;
            }
            .border-top {
                border-top: 1px solid rgba(0, 0, 0, 0.8);
            }
            .border-bottom {
                border-bottom: 1px solid rgba(0, 0, 0, 0.8);
            }

            .border-bottom-dotted {
                border-bottom: 1px dotted rgba(0, 0, 0, 0.8);
            }
            .product-table td,
            .product-table th {
                border: 1px solid rgba(0, 0, 0, 0.8);
                padding: 3px;
            }
            td.serial_number,
            th.serial_number {
                width: 8%;
                max-width: 8%;
            }
            .textbox-info p,
            .textbox-info div {
                font-size: <?php echo e($textboxInfo, false); ?>;
            }
            td.description,
            th.description {
                width: 35%;
                max-width: 35%;
            }
            td.quantity,
            th.quantity {
                width: 10%;
                max-width: 10%;
                word-break: break-all;
            }
            td.unit_price,
            th.unit_price {
                width: 17%;
                max-width: 17%;
                word-break: break-all;
            }
            td.price,
            th.price {
                width: 20%;
                max-width: 20%;
                word-break: break-all;
            }
            td.discount,
            th.discount {
                width: 10%;
                max-width: 10%;
                word-break: break-all;
            }
            .centered {
                text-align: center;
                align-content: center;
                margin: 5px 0;
            }
            .ticket {
                width: 100%;
                max-width: 100%;
                padding-right: 5px;
                /* margin-top: 250px; */
            }
            img {
                max-width: inherit;
                width: auto;
            }
            .hidden-print,
            .hidden-print * {
                display: none !important;
            }
        }
        .table-info {
            width: 100%;
        }
        .table-info tr:first-child td,
        .table-info tr:first-child th {
            padding-top: 9px;
        }
        .table-info th {
            text-align: left;
        }
        .table-info td {
            text-align: center;
        }
        .logo {
            float: left;
            width: 35%;
            padding: 10px;
        }
        .text-with-image {
            float: left;
            width: 65%;
        }
        .text-box {
            width: 100%;
            height: auto;
        }
        .textbox-info {
            clear: both;
        }
        .textbox-info p {
            margin-bottom: 0px
        }
        .flex-box {
            display: flex;
            width: 100%;
        }
        .flex-box p {
            width: 50%;
            margin-bottom: 0px;
            white-space: nowrap;
        }
        .table-f-12 th,
        .table-f-12 td {
            font-size: <?php echo e($th, false); ?>;
            word-break: break-word;
            font-weight: bold;
        }
        .bw {
            word-break: break-word;
        }
    </style>
</head>

<body>
    <div class="ticket">
        <?php if(empty($receipt_details->letter_head)): ?>
            <?php if(!empty($receipt_details->logo)): ?>
                <div class="text-box centered">
                    <img style="max-height: 100px; width: auto;" src="<?php echo e($receipt_details->logo, false); ?>" alt="Logo">
                </div>
            <?php endif; ?>
            <div class="text-box">
                <!-- Logo -->
                <p class="centered">
                    <!-- Header text -->
                    <?php if(!empty($receipt_details->header_text)): ?>
                        <span class="headings"><?php echo $receipt_details->header_text; ?></span>
                        <br />
                    <?php endif; ?>

                    <!-- business information here -->
                    <?php if(!empty($receipt_details->display_name)): ?>
                        <span class="headings">
                            <?php echo e($receipt_details->display_name, false); ?>

                        </span>
                        <br />
                    <?php endif; ?>

                    <?php if(!empty($receipt_details->address)): ?>
                        <?php echo $receipt_details->address; ?>

                        <br />
                    <?php endif; ?>
                    <span style="font-size: 12px">
                        <?php if(!empty($receipt_details->contact)): ?>
                            <?php echo $receipt_details->contact; ?>

                        <?php endif; ?>
                        <?php if(!empty($receipt_details->contact) && !empty($receipt_details->website)): ?>
                            ,
                        <?php endif; ?>
                        <?php if(!empty($receipt_details->website)): ?>
                            <?php echo e($receipt_details->website, false); ?>

                        <?php endif; ?>
                        <?php if(!empty($receipt_details->location_custom_fields)): ?>
                            <br><?php echo e($receipt_details->location_custom_fields, false); ?>

                        <?php endif; ?>

                        <?php if(!empty($receipt_details->sub_heading_line1)): ?>
                            <?php echo e($receipt_details->sub_heading_line1, false); ?><br />
                        <?php endif; ?>
                        <?php if(!empty($receipt_details->sub_heading_line2)): ?>
                            <?php echo e($receipt_details->sub_heading_line2, false); ?><br />
                        <?php endif; ?>
                        <?php if(!empty($receipt_details->sub_heading_line3)): ?>
                            <?php echo e($receipt_details->sub_heading_line3, false); ?><br />
                        <?php endif; ?>
                        <?php if(!empty($receipt_details->sub_heading_line4)): ?>
                            <?php echo e($receipt_details->sub_heading_line4, false); ?><br />
                        <?php endif; ?>
                        <?php if(!empty($receipt_details->sub_heading_line5)): ?>
                            <?php echo e($receipt_details->sub_heading_line5, false); ?><br />
                        <?php endif; ?>

                        <?php if(!empty($receipt_details->tax_info1)): ?>
                            <br><b><?php echo e($receipt_details->tax_label1, false); ?></b> <?php echo e($receipt_details->tax_info1, false); ?>

                        <?php endif; ?>

                        <?php if(!empty($receipt_details->tax_info2)): ?>
                            <b><?php echo e($receipt_details->tax_label2, false); ?></b> <?php echo e($receipt_details->tax_info2, false); ?>

                        <?php endif; ?>
                    </span>

                    <!-- Title of receipt -->
                    <?php if(!empty($receipt_details->invoice_heading)): ?>
                        <br /><span class="sub-headings"><?php echo $receipt_details->invoice_heading; ?></span>
                    <?php endif; ?>
                </p>
            </div>
        <?php else: ?>
            <div class="text-box">
                <img style="width: 100%;margin-bottom: 10px;" src="<?php echo e($receipt_details->letter_head, false); ?>">
            </div>
        <?php endif; ?>
        <div class="border-top textbox-info">
            <p class="f-left sub-headings"><strong><?php echo $receipt_details->invoice_no_prefix; ?></strong></p>
            <p class="f-right sub-headings">
                <?php echo e($receipt_details->invoice_no, false); ?>

            </p>
        </div>
        <div class="textbox-info sub-headings">
            <p class="f-left"><strong><?php echo $receipt_details->date_label; ?></strong></p>
            <p class="f-right">
                <?php echo e($receipt_details->invoice_date, false); ?>

            </p>
        </div>

        <?php if(!empty($receipt_details->due_date_label)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong><?php echo e($receipt_details->due_date_label, false); ?></strong></p>
                <p class="f-right"><?php echo e($receipt_details->due_date ?? '', false); ?></p>
            </div>
        <?php endif; ?>

        <?php if(!empty($receipt_details->sales_person_label)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong><?php echo e($receipt_details->sales_person_label, false); ?></strong></p>

                <p class="f-right"><?php echo e($receipt_details->sales_person, false); ?></p>
            </div>
        <?php endif; ?>
        <?php if(!empty($receipt_details->commission_agent_label)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong><?php echo e($receipt_details->commission_agent_label, false); ?></strong></p>

                <p class="f-right"><?php echo e($receipt_details->commission_agent, false); ?></p>
            </div>
        <?php endif; ?>

        <!-- customer info -->
        <div class="textbox-info">
            <p style="vertical-align: top;"><strong>
                    <?php echo e($receipt_details->customer_label ?? '', false); ?>

                </strong></p>

            <p>
                <?php if(!empty($receipt_details->customer_info)): ?>
                    <div class="bw sub-headings">
                        <?php echo $receipt_details->customer_info; ?>

                    </div>
                <?php endif; ?>
            </p>
        </div>

        <?php if(!empty($receipt_details->client_id_label)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong>
                        <?php echo e($receipt_details->client_id_label, false); ?>

                    </strong></p>
                <p class="f-right">
                    <?php echo e($receipt_details->client_id, false); ?>

                </p>
            </div>
        <?php endif; ?>

        <?php if(!empty($receipt_details->customer_tax_label)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong>
                        <?php echo e($receipt_details->customer_tax_label, false); ?>

                    </strong></p>
                <p class="f-right">
                    <?php echo e($receipt_details->customer_tax_number, false); ?>

                </p>
            </div>
        <?php endif; ?>

        <?php if(!empty($receipt_details->customer_custom_fields)): ?>
            <div class="textbox-info">
                <p class="centered">
                    <?php echo $receipt_details->customer_custom_fields; ?>

                </p>
            </div>
        <?php endif; ?>

        <?php if(!empty($receipt_details->customer_rp_label)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong>
                        <?php echo e($receipt_details->customer_rp_label, false); ?>

                    </strong></p>
                <p class="f-right">
                    <?php echo e($receipt_details->customer_total_rp, false); ?>

                </p>
            </div>
        <?php endif; ?>
        
        <?php if(!empty($receipt_details->sale_orders_invoice_no)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong>
                        <?php echo app('translator')->get('restaurant.order_no'); ?>
                    </strong></p>
                <p class="f-right">
                    <?php echo $receipt_details->sale_orders_invoice_no ?? ''; ?>

                </p>
            </div>
        <?php endif; ?>

        <?php if(!empty($receipt_details->sale_orders_invoice_date)): ?>
            <div class="textbox-info">
                <p class="f-left"><strong>
                        <?php echo app('translator')->get('lang_v1.order_dates'); ?>
                    </strong></p>
                <p class="f-right">
                    <?php echo $receipt_details->sale_orders_invoice_date ?? ''; ?>

                </p>
            </div>
        <?php endif; ?>
        
        <?php if(!empty($receipt_details->total_quantity_label)): ?>
            <div class="flex-box">
                <p class="left text-right">
                    <?php echo $receipt_details->total_quantity_label; ?>

                </p>
                <p class="width-50 text-right">
                    <?php echo e($receipt_details->total_quantity, false); ?>

                </p>
            </div>
        <?php endif; ?>
        <?php if(!empty($receipt_details->total_items_label)): ?>
            <div class="flex-box">
                <p class="left text-right">
                    <?php echo $receipt_details->total_items_label; ?>

                </p>
                <p class="width-50 text-right">
                    <?php echo e($receipt_details->total_items, false); ?>

                </p>
            </div>
        <?php endif; ?>

        <div class="flex-box">
            <p class="width-50 text-right sub-headings"><?php echo $receipt_details->total_due_label; ?></p>
            <p class="width-50 text-right sub-headings">
                <?php echo e(convert_number_to_bangla($receipt_details->total_due), false); ?>

            </p>
        </div>
        <div class="flex-box">
            <p class="width-50 text-right sub-headings"><?php echo $receipt_details->today_pay_label; ?></p>
            <p class="width-50 text-right sub-headings">
                <?php echo e(convert_number_to_bangla($receipt_details->today_pay), false); ?>

            </p>
        </div>
        <div class="flex-box">
            <p class="width-50 text-right sub-headings"><?php echo $receipt_details->rest_of_due_label; ?></p>
            <p class="width-50 text-right sub-headings">
                <?php echo e(convert_number_to_bangla($receipt_details->rest_of_due), false); ?>

            </p>
        </div>

        <div class="border-bottom width-100">&nbsp;</div>

        <?php if(!empty($receipt_details->additional_notes)): ?>
            <p class="centered">
                <?php echo nl2br($receipt_details->additional_notes); ?>

            </p>
        <?php endif; ?>

        <?php if(!empty($receipt_details->footer_message)): ?>
            <p class="centered">
                <?php echo $receipt_details->footer_message; ?>

            </p>
        <?php endif; ?>

        <?php if(!empty($receipt_details->footer_text)): ?>
            <p class="centered">
                <?php echo $receipt_details->footer_text; ?>

            </p>
        <?php endif; ?>

    </div>
    <!-- <button id="btnPrint" class="hidden-print">Print</button>
        <script src="script.js"></script> -->
</body>

</html>
<?php /**PATH /home/purobitech/salam.purobitechnology.com/resources/views/sale_pos/receipts/due.blade.php ENDPATH**/ ?>