<script type="text/javascript">
    $(document).ready(function() {

        //Date range as a button
        $('#transport_list_filter_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#transport_list_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(
                    moment_date_format));
                    transport_table.ajax.reload();
            }
        );
        $('#transport_list_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $('#transport_list_filter_date_range').val('');
            transport_table.ajax.reload();
        });

        $(document).on('change',
            '#transport_list_filter_location_id, #transport_list_filter_customer_id, #transport_list_filter_payment_status, #created_by, #sales_cmsn_agnt, #service_staffs, #shipping_status',
            function() {
                transport_table.ajax.reload();
            });

        $('#only_subscriptions').on('ifChanged', function(event) {
            transport_table.ajax.reload();
        });

        transport_table = $('#transport_table').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [
                [1, 'desc']
            ],
            scrollY: "75vh",
            scrollX: true,
            scrollCollapse: true,
            "ajax": {
                "url": "/sells?transporter=1",
                "data": function(d) {
                    if ($('#sell_list_filter_date_range').val()) {
                        var start = $('#sell_list_filter_date_range').data('daterangepicker')
                            .startDate.format('YYYY-MM-DD');
                        var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate
                            .format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    if ($('#is_direct_sale').length) {
                        d.is_direct_sale = $('#is_direct_sale').val();
                    }

                    if ($('#sell_list_filter_location_id').length) {
                        d.location_id = $('#sell_list_filter_location_id').val();
                    }
                    d.customer_id = $('#sell_list_filter_customer_id').val();

                    if ($('#sell_list_filter_payment_status').length) {
                        d.payment_status = $('#sell_list_filter_payment_status').val();
                    }
                    if ($('#created_by').length) {
                        d.created_by = $('#created_by').val();
                    }
                    if ($('#sales_cmsn_agnt').length) {
                        d.sales_cmsn_agnt = $('#sales_cmsn_agnt').val();
                    }
                    if ($('#service_staffs').length) {
                        d.service_staffs = $('#service_staffs').val();
                    }

                    if ($('#shipping_status').length) {
                        d.shipping_status = $('#shipping_status').val();
                    }

                    if ($('#only_subscriptions').length && $('#only_subscriptions').is(
                        ':checked')) {
                        d.only_subscriptions = 1;
                    }

                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [{
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    "searchable": false
                },
                {
                    data: 'transaction_date',
                    name: 'transaction_date'
                },
                {
                    data: 'invoice_no',
                    name: 'invoice_no'
                },
                {
                    data: 'conatct_name',
                    name: 'conatct_name'
                },
                {
                    data: 'mobile',
                    name: 'contacts.mobile'
                },
                {
                    data: 'business_location',
                    name: 'bl.name'
                },
                {
                    data: 'payment_status',
                    name: 'payment_status'
                },
                {
                    data: 'payment_methods',
                    orderable: false,
                    "searchable": false
                },
                {
                    data: 'final_total',
                    name: 'final_total'
                },
                {
                    data: 'total_paid',
                    name: 'total_paid',
                    "searchable": false
                },
                {
                    data: 'total_remaining',
                    name: 'total_remaining'
                },
                {
                    data: 'return_due',
                    orderable: false,
                    "searchable": false
                },
                {
                    data: 'shipping_status',
                    name: 'shipping_status'
                },
                {
                    data: 'total_items',
                    name: 'total_items',
                    "searchable": false
                },
                {
                    data: 'types_of_service_name',
                    name: 'tos.name',
                    <?php if(empty($is_types_service_enabled)): ?>
                        visible: false
                    <?php endif; ?>
                },
                {
                    data: 'service_custom_field_1',
                    name: 'service_custom_field_1',
                    <?php if(empty($is_types_service_enabled)): ?>
                        visible: false
                    <?php endif; ?>
                },
                {
                    data: 'added_by',
                    name: 'u.first_name'
                },
                {
                    data: 'additional_notes',
                    name: 'additional_notes'
                },
                {
                    data: 'staff_note',
                    name: 'staff_note'
                },
                {
                    data: 'shipping_details',
                    name: 'shipping_details'
                },
                {
                    data: 'table_name',
                    name: 'tables.name',
                    <?php if(empty($is_tables_enabled)): ?>
                        visible: false
                    <?php endif; ?>
                },
                {
                    data: 'waiter',
                    name: 'ss.first_name',
                    <?php if(empty($is_service_staff_enabled)): ?>
                        visible: false
                    <?php endif; ?>
                }
            ],
            "fnDrawCallback": function(oSettings) {
                __currency_convert_recursively($('#sell_table'));
            },
            "footerCallback": function(row, data, start, end, display) {
                var footer_sale_total = 0;
                var footer_total_paid = 0;
                var footer_total_remaining = 0;
                var footer_total_sell_return_due = 0;
                for (var r in data) {
                    footer_sale_total += $(data[r].final_total).data('orig-value') ? parseFloat($(
                        data[r].final_total).data('orig-value')) : 0;
                    footer_total_paid += $(data[r].total_paid).data('orig-value') ? parseFloat($(
                        data[r].total_paid).data('orig-value')) : 0;
                    footer_total_remaining += $(data[r].total_remaining).data('orig-value') ?
                        parseFloat($(data[r].total_remaining).data('orig-value')) : 0;
                    footer_total_sell_return_due += $(data[r].return_due).find('.sell_return_due')
                        .data('orig-value') ? parseFloat($(data[r].return_due).find(
                            '.sell_return_due').data('orig-value')) : 0;
                }

                $('.footer_total_sell_return_due').html(__currency_trans_from_en(
                    footer_total_sell_return_due));
                $('.footer_total_remaining').html(__currency_trans_from_en(footer_total_remaining));
                $('.footer_total_paid').html(__currency_trans_from_en(footer_total_paid));
                $('.footer_sale_total').html(__currency_trans_from_en(footer_sale_total));

                $('.footer_payment_status_count').html(__count_status(data, 'payment_status'));
                $('.service_type_count').html(__count_status(data, 'types_of_service_name'));
                $('.payment_method_count').html(__count_status(data, 'payment_methods'));
            },
            createdRow: function(row, data, dataIndex) {
                $(row).find('td:eq(6)').attr('class', 'clickable_td');
            }
        });

        $('a[href="#transports_tab"]').on('shown.bs.tab', function(e) {
            transport_table.ajax.reload();
        });
    });
</script>
<?php /**PATH /home/purobitech/salam.purobitechnology.com/resources/views/sale_pos/partials/transport_table_javascript.blade.php ENDPATH**/ ?>