<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!--Bootstrap CSS only -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-0evHe/X+R7YkIZDRvuzKMRqM+OrBnVFBL6DOitfPri4tjfHxaWutUpFmBp4vmVor" crossorigin="anonymous">
    <link rel="stylesheet" href="<?php echo e(mix('css/login.css'), false); ?>">
    <link href="https://fonts.googleapis.com/css?family=Material+Icons|Material+Icons+Outlined|Material+Icons+Two+Tone|Material+Icons+Round|Material+Icons+Sharp" rel="stylesheet">

    <title><?php echo $__env->yieldContent('title', 'Login'); ?> - <?php echo e(config('app.name'), false); ?></title>
</head>

<body style="background-image: url('img/login-background.jpg')">

    <!-- *---------------------------------Login------------------* -->
    <div class="main-body">
        <div class="row  justify-content-md-center">
            
            <div class="col-md-6 col-lg-5 col-xl-4 col-12 col-sm-9 mx-auto py-5">
                <div class="sign-form">
                    <div class="sign-info">
                        <h2 style="margin-bottom:0px"><?php echo app('translator')->get('lang_v1.login'); ?></h2>
                    </div>
                    <?php
                        $username = old('username');
                        $password = null;
                        if (config('app.env') == 'demo') {
                            $username = 'admin';
                            $password = '12345678';
                        
                            $demo_types = [
                                'all_in_one' => 'admin',
                                'super_market' => 'admin',
                                'pharmacy' => 'admin-pharmacy',
                                'electronics' => 'admin-electronics',
                                'services' => 'admin-services',
                                'restaurant' => 'admin-restaurant',
                                'superadmin' => 'superadmin',
                                'woocommerce' => 'woocommerce_user',
                                'essentials' => 'admin-essentials',
                                'manufacturing' => 'manufacturer-demo',
                            ];
                        
                            if (!empty($_GET['demo_type']) && array_key_exists($_GET['demo_type'], $demo_types)) {
                                $username = $demo_types[$_GET['demo_type']];
                            }
                        }
                    ?>

                    <form class="form" method="POST" action="<?php echo e(route('login'), false); ?>" id="login-form">
                        <?php echo e(csrf_field(), false); ?>

                        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['input-field form-group has-feedback', 'has-error' => $errors->has('username')]) ?>">
                            <label for="username">User name</label>
                            <input type="text" id="username" class="form-control" name="username" value="<?php echo e($username, false); ?>" required autofocus>
                            
                            <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="help-block">
                                    <p class="text-danger"><?php echo e($message, false); ?></p>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['input-field form-group has-feedback', 'has-error' => $errors->has('password')]) ?>">
                            <label for="password">Password</label>
                            <input id="password" type="password" class="form-control" name="password" value="<?php echo e($password, false); ?>" required>
                            
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="help-block">
                                    <p class="text-danger"><?php echo e($message, false); ?></p>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="checkbox-field justify-content-between">
                            <span class="d-flex align-items-baseline pb-2">
                                <input type="checkbox" name="remember" id="remember" <?php if(old('remember')): echo 'checked'; endif; ?>>
                                <p style="margin-left:5px"><label for="remember"><?php echo app('translator')->get('lang_v1.remember_me'); ?></label></p>
                            </span>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="submit-button"><?php echo app('translator')->get('lang_v1.login'); ?></button>
                            <?php if(config('app.env') != 'demo'): ?>
                                <a href="<?php echo e(route('password.request'), false); ?>" class="pull-right">
                                    <?php echo app('translator')->get('lang_v1.forgot_your_password'); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </form>

                    <div class="signup-footer my-5">
                        <img src="<?php echo e(asset('img/purobi.png'), false); ?>" style="width:60%" alt="">
                    </div>

                    <div style="text-align: left;">
                        <select class="form-control input-sm" id="change_lang" style="margin: 10px;">
                            <?php $__currentLoopData = config('constants.langs'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key, false); ?>" 
                                    <?php if( (empty(request()->lang) && config('app.locale') == $key) 
                                    || request()->lang == $key): ?> 
                                        selected 
                                    <?php endif; ?>
                                >
                                    <?php echo e($val['full_name'], false); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <?php echo $__env->make('layouts.partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- Scripts -->
    <script src="<?php echo e(asset('js/login.js?v=' . $asset_v), false); ?>"></script>

    <script>
        $(function(){
            $(document).on('change', '#change_lang', function(){
                window.location = "<?php echo e(route('login'), false); ?>?lang=" + $(this).val();
            });
    
            $('a.demo-login').click( function (e) {
               e.preventDefault();
               $('#username').val($(this).data('admin'));
               $('#password').val("<?php echo e($password, false); ?>");
               $('form#login-form').submit();
            });
        });
    </script>
</body>

</html>
<?php /**PATH /home/purobitech/salam.purobitechnology.com/resources/views/auth/login.blade.php ENDPATH**/ ?>