@extends('layouts.app')
@section('title', __('sale.transactions'))

@section('content')

<style>
    .dataTables_scrollHeadInner,
    .dataTable {
        width: 100% !important;
    }
</style>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('sale.transactions')</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    @component('components.filters', ['title' => __('report.filters')]) 

        <div class="col-md-3">
            <div class="form-group">
                {!! Form::label('payments_filter_contact_id', __('contact.customer') . ':') !!}
                {!! Form::select('payments_filter_contact_id', $customers, null, [
                    'class' => 'form-control select2',
                    'style' => 'width:100%',
                    'id' => 'payments_filter_contact_id',
                    'placeholder' => __('lang_v1.all'),
                ]) !!}
            </div>
        </div>
        @if (isMainAdmin())
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('created_by', __('report.user') . ':') !!}
                    {!! Form::select('created_by', $users, null, [
                        'class' => 'form-control select2',
                        'style' => 'width:100%',
                        'id' => 'created_by',
                        'placeholder' => __('lang_v1.all'),
                    ]) !!}
                </div>
            </div>
        @endif
        
        <div class="col-md-3">
            <div class="form-group">
                {!! Form::label('payments_filter_date_range', __('report.date_range') . ':') !!}
                {!! Form::text('payments_filter_date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly']); !!}
            </div>
        </div>
    @endcomponent

    <div class="box">
        <div class="box-header">
            <h3 class="box-title">@lang( 'sale.all_transactions' )</h3>
        </div>
        <div class="box-body">
            <table class="table table-bordered table-striped" id="payments_table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('messages.date')</th>
                        <th>@lang('sale.customer_name')</th>
                        <th>@lang('brand.type')</th>
                        <th>@lang('brand.payment_type')</th>
                        <th>@lang('purchase.amount')</th>
                        <th>@lang('lang_v1.hand_cash')</th>
                        <th>@lang('purchase.payment_note')</th>
                        <th>@lang('lang_v1.added_by')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td colspan="5">
                            <strong>@lang('lang_v1.hand_cash'):</strong>
                            {{-- (
                                <span>@lang('account.credit'): <span class="payment_total_credit"></span></span>
                                -
                                <span>@lang('account.debit'): <span class="payment_total_debit"></span></span>
                            ) --}}
                        </td>
                        <td class="payment_total_amount"></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <div class="modal fade payment_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>
</section>
<!-- /.content -->

@endsection


@section('javascript')
<script type="text/javascript">
$(document).ready( function(){
    //Date range as a button
    $('#payments_filter_date_range').daterangepicker(
        dateRangeSettings,
        function (start, end) {
            $('#payments_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            payments_table.ajax.reload();
        }
    );
    $('#payments_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
        $('#payments_filter_date_range').val('');
        payments_table.ajax.reload();
    });

    payments_table = $('#payments_table').DataTable({
        processing: true,
        serverSide: true,
        aaSorting: [[0, 'desc']],
        "ajax": {
            "url": "/payments",
            "data": function ( d ) {
                if($('#payments_filter_date_range').val()) {
                    var start = $('#payments_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var end = $('#payments_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                    d.start_date = start;
                    d.end_date = end;
                }
                d.contact_id = $('#payments_filter_contact_id').val();
                d.staff_name = $('#created_by').val();

                d = __datatable_ajax_callback(d);
            }
        },
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        columns: [
            { data: 'DT_Row_Index', name: 'id'},
            { data: 'created_at', name: 'created_at'},
            { data: 'contact_name', name: 'contact_name', orderable: false, searchable: false},
            { data: 'type', name: 'type'},
            { data: 'payment_type', name: 'payment_type'},
            { data: 'amount', name: 'amount'},
            { data: 'hand_cash', name: 'hand_cash'},
            { data: 'note', name: 'note'},
            { data: 'user_name', name: 'user.first_name'},
            { data: 'action', name: 'action', orderable: false, searchable: false},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            let hand_cash = 0;
            hand_cash = data.length ? data[0].current_hand_cash : 0;
            $('.payment_total_amount').empty().text(hand_cash);
        },
    });

    $(document).on('change', '#payments_filter_contact_id, #created_by, #sell_list_filter_payment_status, #created_by, #sales_cmsn_agnt, #service_staffs, #shipping_status, #sell_list_filter_source',  function() {
        payments_table.ajax.reload();
    });

    $('#only_subscriptions').on('ifChanged', function(event){
        payments_table.ajax.reload();
    });
});
</script>
@endsection