@extends('layouts.app')
@section('title', __('lang_v1.all_trades'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('lang_v1.trade')</h1>
    {{-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> --}}
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_trades')])
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>@lang('lang_v1.type')</th>
                        <th>@lang('lang_v1.amount')</th>
                        <th>@lang('lang_v1.date')</th>
                    </tr>
                </thead>
                @php
                    $util = new \App\Utils\Util;
                    $willGive = 0;
                    $willGet  = 0;
                @endphp
				<tbody>
					@foreach ($trade->contact?->trades as $item)
                        @if($item->is_will_get)
                            @php($willGet += $item->amount)
                        @else
                            @php($willGive += $item->amount)
                        @endif
                        <tr>
                            <td>{{ $item->is_will_get ? '(+)'.__('lang_v1.will_get'):'(-)'.__('lang_v1.will_give') }}</td>
                            <td>{{ $util->num_f($item->amount, true) }}</td>
                            <td>{{ $item->created_at->format('d-m-Y g:i A') }}</td>
                        </tr>
					@endforeach
				</tbody>
				<tfoot>
					<tr>
                        @php($text = $willGet > $willGive ? '(+)'.__('lang_v1.will_get'):'(-)'.__('lang_v1.will_give'))
						<th class="text-right">Total:</th>
						<th colspan="2">{{ $text }} {{ $util->num_f($willGet > $willGive ? ($willGet - $willGive) : ($willGive - $willGet), true) }}</th>
					</tr>
				</tfoot>
            </table>
        </div>
    @endcomponent

</section>
<!-- /.content -->

@endsection
