@extends('layouts.app')
@section('title', __('lang_v1.all_trades'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('lang_v1.trade')</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_trades')])
        @slot('tool')
            <div class="box-tools">
                <button type="button" class="btn btn-block btn-primary btn-modal" 
                data-href="{{action([\App\Http\Controllers\TradeController::class, 'create'])}}" 
                data-container=".trade_modal">
                <i class="fa fa-plus"></i> @lang('messages.add')</button>
            </div>
        @endslot
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="trade_table">
                <thead>
                    <tr>
                        <th>@lang('contact.name')</th>
                        <th>@lang('lang_v1.type')</th>
                        <th>@lang('lang_v1.amount')</th>
                        <th>@lang('lang_v1.date')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>Total: {{ $total_trade }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent

    <div class="modal fade trade_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

@endsection
