<!-- business information here -->
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!-- <link rel="stylesheet" href="style.css"> -->
    <title>Receipt-{{ $receipt_details->invoice_no }}</title>
    @php
        $locale = 'bn';
        $f8 = $locale == 'en' ? '11px' : '7px';
        $headings = $locale == 'en' ? '16px' : '12px';
        $subHeadings = $locale == 'en' ? '14px' : '14px';
        $th = $locale == 'en' ? '12px' : '11px';
        $print = $locale == 'en' ? '11px' : '10px';
        $textboxInfo = $locale == 'en' ? '12px' : '12px';
    @endphp
	
    <style type="text/css">
        .f-8 {
            font-size: {{ $f8 }} !important;
        }
        body {
            color: #000000;
        }
        @media print {
            * {
                font-size: {{ $print }};
                font-family: 'Times New Roman';
                word-break: break-all;
            }
            .f-8 {
                font-size: {{ $f8 }} !important;
            }
            .headings {
                font-size: {{ $headings }};
                font-weight: 600;
                text-transform: uppercase;
                white-space: nowrap;
            }
            .sub-headings {
                font-size: {{ $subHeadings }} !important;
                font-weight: 600 !important;
            }
            .border-top {
                border-top: 1px solid rgba(0, 0, 0, 0.8);
            }
            .border-bottom {
                border-bottom: 1px solid rgba(0, 0, 0, 0.8);
            }

            .border-bottom-dotted {
                border-bottom: 1px dotted rgba(0, 0, 0, 0.8);
            }
            .product-table td,
            .product-table th {
                border: 1px solid rgba(0, 0, 0, 0.8);
                padding: 3px;
            }
            td.serial_number,
            th.serial_number {
                width: 8%;
                max-width: 8%;
            }
            .textbox-info p,
            .textbox-info div {
                font-size: {{ $textboxInfo }};
            }
            td.description,
            th.description {
                width: 35%;
                max-width: 35%;
            }
            td.quantity,
            th.quantity {
                width: 10%;
                max-width: 10%;
                word-break: break-all;
            }
            td.unit_price,
            th.unit_price {
                width: 17%;
                max-width: 17%;
                word-break: break-all;
            }
            td.price,
            th.price {
                width: 20%;
                max-width: 20%;
                word-break: break-all;
            }
            td.discount,
            th.discount {
                width: 10%;
                max-width: 10%;
                word-break: break-all;
            }
            .centered {
                text-align: center;
                align-content: center;
                margin: 5px 0;
            }
            .ticket {
                width: 100%;
                max-width: 100%;
                padding-right: 5px;
                /* margin-top: 250px; */
            }
            img {
                max-width: inherit;
                width: auto;
            }
            .hidden-print,
            .hidden-print * {
                display: none !important;
            }
        }
        .table-info {
            width: 100%;
        }
        .table-info tr:first-child td,
        .table-info tr:first-child th {
            padding-top: 9px;
        }
        .table-info th {
            text-align: left;
        }
        .table-info td {
            text-align: center;
        }
        .logo {
            float: left;
            width: 35%;
            padding: 10px;
        }
        .text-with-image {
            float: left;
            width: 65%;
        }
        .text-box {
            width: 100%;
            height: auto;
        }
        .textbox-info {
            clear: both;
        }
        .textbox-info p {
            margin-bottom: 0px
        }
        .flex-box {
            display: flex;
            width: 100%;
        }
        .flex-box p {
            width: 50%;
            margin-bottom: 0px;
            white-space: nowrap;
        }
        .table-f-12 th,
        .table-f-12 td {
            font-size: {{ $th }};
            word-break: break-word;
            font-weight: bold;
        }
        .bw {
            word-break: break-word;
        }
    </style>
</head>

<body>
    <div class="ticket">
        @if (empty($receipt_details->letter_head))
            @if (!empty($receipt_details->logo))
                <div class="text-box centered">
                    <img style="max-height: 100px; width: auto;" src="{{ $receipt_details->logo }}" alt="Logo">
                </div>
            @endif
            <div class="text-box">
                <!-- Logo -->
                <p class="centered">
                    <!-- Header text -->
                    @if (!empty($receipt_details->header_text))
                        <span class="headings">{!! $receipt_details->header_text !!}</span>
                        <br />
                    @endif

                    <!-- business information here -->
                    @if (!empty($receipt_details->display_name))
                        <span class="headings">
                            {{ $receipt_details->display_name }}
                        </span>
                        <br />
                    @endif

                    @if (!empty($receipt_details->address))
                        {!! $receipt_details->address !!}
                        <br />
                    @endif
                    <span style="font-size: 12px">
                        @if (!empty($receipt_details->contact))
                            {!! $receipt_details->contact !!}
                        @endif
                        @if (!empty($receipt_details->contact) && !empty($receipt_details->website))
                            ,
                        @endif
                        @if (!empty($receipt_details->website))
                            {{ $receipt_details->website }}
                        @endif
                        @if (!empty($receipt_details->location_custom_fields))
                            <br>{{ $receipt_details->location_custom_fields }}
                        @endif

                        @if (!empty($receipt_details->sub_heading_line1))
                            {{ $receipt_details->sub_heading_line1 }}<br />
                        @endif
                        @if (!empty($receipt_details->sub_heading_line2))
                            {{ $receipt_details->sub_heading_line2 }}<br />
                        @endif
                        @if (!empty($receipt_details->sub_heading_line3))
                            {{ $receipt_details->sub_heading_line3 }}<br />
                        @endif
                        @if (!empty($receipt_details->sub_heading_line4))
                            {{ $receipt_details->sub_heading_line4 }}<br />
                        @endif
                        @if (!empty($receipt_details->sub_heading_line5))
                            {{ $receipt_details->sub_heading_line5 }}<br />
                        @endif

                        @if (!empty($receipt_details->tax_info1))
                            <br><b>{{ $receipt_details->tax_label1 }}</b> {{ $receipt_details->tax_info1 }}
                        @endif

                        @if (!empty($receipt_details->tax_info2))
                            <b>{{ $receipt_details->tax_label2 }}</b> {{ $receipt_details->tax_info2 }}
                        @endif
                    </span>

                    <!-- Title of receipt -->
                    @if (!empty($receipt_details->invoice_heading))
                        <br /><span class="sub-headings">{!! $receipt_details->invoice_heading !!}</span>
                    @endif
                </p>
            </div>
        @else
            <div class="text-box">
                <img style="width: 100%;margin-bottom: 10px;" src="{{ $receipt_details->letter_head }}">
            </div>
        @endif
        <div class="border-top textbox-info">
            <p class="f-left sub-headings"><strong>{!! $receipt_details->invoice_no_prefix !!}</strong></p>
            <p class="f-right sub-headings">
                {{ $receipt_details->invoice_no }}
            </p>
        </div>
        <div class="textbox-info sub-headings">
            <p class="f-left"><strong>{!! $receipt_details->date_label !!}</strong></p>
            <p class="f-right">
                {{ $receipt_details->invoice_date }}
            </p>
        </div>

        @if (!empty($receipt_details->due_date_label))
            <div class="textbox-info">
                <p class="f-left"><strong>{{ $receipt_details->due_date_label }}</strong></p>
                <p class="f-right">{{ $receipt_details->due_date ?? '' }}</p>
            </div>
        @endif

        @if (!empty($receipt_details->sales_person_label))
            <div class="textbox-info">
                <p class="f-left"><strong>{{ $receipt_details->sales_person_label }}</strong></p>

                <p class="f-right">{{ $receipt_details->sales_person }}</p>
            </div>
        @endif
        @if (!empty($receipt_details->commission_agent_label))
            <div class="textbox-info">
                <p class="f-left"><strong>{{ $receipt_details->commission_agent_label }}</strong></p>

                <p class="f-right">{{ $receipt_details->commission_agent }}</p>
            </div>
        @endif

        <!-- customer info -->
        <div class="textbox-info">
            <p style="vertical-align: top;"><strong>
                    {{ $receipt_details->customer_label ?? '' }}
                </strong></p>

            <p>
                @if (!empty($receipt_details->customer_info))
                    <div class="bw sub-headings">
                        {!! $receipt_details->customer_info !!}
                    </div>
                @endif
            </p>
        </div>

        @if (!empty($receipt_details->client_id_label))
            <div class="textbox-info">
                <p class="f-left"><strong>
                        {{ $receipt_details->client_id_label }}
                    </strong></p>
                <p class="f-right">
                    {{ $receipt_details->client_id }}
                </p>
            </div>
        @endif

        @if (!empty($receipt_details->customer_tax_label))
            <div class="textbox-info">
                <p class="f-left"><strong>
                        {{ $receipt_details->customer_tax_label }}
                    </strong></p>
                <p class="f-right">
                    {{ $receipt_details->customer_tax_number }}
                </p>
            </div>
        @endif

        @if (!empty($receipt_details->customer_custom_fields))
            <div class="textbox-info">
                <p class="centered">
                    {!! $receipt_details->customer_custom_fields !!}
                </p>
            </div>
        @endif

        @if (!empty($receipt_details->customer_rp_label))
            <div class="textbox-info">
                <p class="f-left"><strong>
                        {{ $receipt_details->customer_rp_label }}
                    </strong></p>
                <p class="f-right">
                    {{ $receipt_details->customer_total_rp }}
                </p>
            </div>
        @endif
        
        @if (!empty($receipt_details->sale_orders_invoice_no))
            <div class="textbox-info">
                <p class="f-left"><strong>
                        @lang('restaurant.order_no')
                    </strong></p>
                <p class="f-right">
                    {!! $receipt_details->sale_orders_invoice_no ?? '' !!}
                </p>
            </div>
        @endif

        @if (!empty($receipt_details->sale_orders_invoice_date))
            <div class="textbox-info">
                <p class="f-left"><strong>
                        @lang('lang_v1.order_dates')
                    </strong></p>
                <p class="f-right">
                    {!! $receipt_details->sale_orders_invoice_date ?? '' !!}
                </p>
            </div>
        @endif
        
        @if (!empty($receipt_details->total_quantity_label))
            <div class="flex-box">
                <p class="left text-right">
                    {!! $receipt_details->total_quantity_label !!}
                </p>
                <p class="width-50 text-right">
                    {{ $receipt_details->total_quantity }}
                </p>
            </div>
        @endif
        @if (!empty($receipt_details->total_items_label))
            <div class="flex-box">
                <p class="left text-right">
                    {!! $receipt_details->total_items_label !!}
                </p>
                <p class="width-50 text-right">
                    {{ $receipt_details->total_items }}
                </p>
            </div>
        @endif

        <div class="flex-box">
            <p class="width-50 text-right sub-headings">{!! $receipt_details->total_due_label !!}</p>
            <p class="width-50 text-right sub-headings">
                {{ convert_number_to_bangla($receipt_details->total_due) }}
            </p>
        </div>
        <div class="flex-box">
            <p class="width-50 text-right sub-headings">{!! $receipt_details->today_pay_label !!}</p>
            <p class="width-50 text-right sub-headings">
                {{ convert_number_to_bangla($receipt_details->today_pay) }}
            </p>
        </div>
        <div class="flex-box">
            <p class="width-50 text-right sub-headings">{!! $receipt_details->rest_of_due_label !!}</p>
            <p class="width-50 text-right sub-headings">
                {{ convert_number_to_bangla($receipt_details->rest_of_due) }}
            </p>
        </div>

        <div class="border-bottom width-100">&nbsp;</div>

        @if (!empty($receipt_details->additional_notes))
            <p class="centered">
                {!! nl2br($receipt_details->additional_notes) !!}
            </p>
        @endif

        @if (!empty($receipt_details->footer_message))
            <p class="centered">
                {!! $receipt_details->footer_message !!}
            </p>
        @endif

        @if (!empty($receipt_details->footer_text))
            <p class="centered">
                {!! $receipt_details->footer_text !!}
            </p>
        @endif

    </div>
    <!-- <button id="btnPrint" class="hidden-print">Print</button>
        <script src="script.js"></script> -->
</body>

</html>
