@extends('layouts.app')
@section('title', __('stock_adjustment.stock_adjustments'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('stock_adjustment.stock_adjustments')</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __('stock_adjustment.stock_adjustments')])
        @slot('tool')
            <div class="box-tools">
                <button type="button" class="btn btn-block btn-primary btn-modal" 
                data-href="{{action([\App\Http\Controllers\ReturnableProductStockController::class, 'create'])}}" 
                data-container=".product_stock_modal">
                <i class="fa fa-plus"></i> @lang('messages.add')</button>
            </div>
        @endslot
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="product_stock_table">
                <thead>
                    <tr>
                        <th>@lang('sale.product')</th>
                        <th>@lang('product.brand')</th>
                        <th>@lang('sale.qty')</th>
                        <th>@lang('lang_v1.date')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th class="text-right" colspan="2">
                            {{__('lang_v1.total_stock') }}({{__('lang_v1.inhouse') }}:{{ $total_stock }} + {{__('lang_v1.return_able') }}:{{ $total_returnable }})
                        </th>
                        <th colspan="3">{{ $total_stock + $total_returnable }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent

    <div class="modal fade product_stock_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

@endsection
