<div class="modal-header">
    <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
    <h4 class="modal-title" id="modalTitle"> @lang('lang_v1.order_details') (<b>@lang('purchase.ref_no'):</b> #{{ $order->ref_no }})
    </h4>
</div>
<div class="modal-body">
    <div class="row">
        <div class="col-sm-12">
            <p class="pull-right"><b>@lang('messages.date'):</b> {{ @format_date($order->transaction_date) }}</p>
        </div>
    </div>
    <div class="row invoice-info">
        <div class="col-sm-4 invoice-col">
            @lang('purchase.supplier'):
            <address>
                {!! $order->contact->contact_address !!}
                @if (!empty($order->contact->tax_number))
                    <br>@lang('contact.tax_no'): {{ $order->contact->tax_number }}
                @endif
                @if (!empty($order->contact->mobile))
                    <br>@lang('contact.mobile'): {{ $order->contact->mobile }}
                @endif
                @if (!empty($order->contact->email))
                    <br>@lang('business.email'): {{ $order->contact->email }}
                @endif
            </address>
            @if ($order->document_path)
                <a href="{{ $order->document_path }}" download="{{ $order->document_name }}"
                    class="btn btn-sm btn-success pull-left no-print">
                    <i class="fa fa-download"></i>
                    &nbsp;{{ __('purchase.download_document') }}
                </a>
            @endif
        </div>

        <div class="col-sm-4 invoice-col">
            <b>@lang('purchase.ref_no'):</b> #{{ $order->ref_no }}<br />
            <b>@lang('messages.date'):</b> {{ @format_date($order->created_at) }}<br />
            
            @if (!empty($order_order_dates))
                <br>
                <strong>@lang('lang_v1.order_dates'):</strong>
                {{ @format_date($order->created_at) }}
            @endif

        </div>
    </div>

    <br>
    <div class="row">
        <div class="col-sm-12 col-xs-12">
            <div class="table-responsive">
                <table class="table bg-gray">
                    <thead>
                        <tr class="bg-green">
                            <th>#</th>
                            <th>@lang('sale.product')</th>
                            <th>@lang('sale.qty')</th>
                        </tr>
                    </thead>
                    @foreach ($order->items as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                {{ $item->product->name }}
                                @if ($item->product->type == 'variable')
                                    - {{ $item->variations->product_variation->name }}
                                    - {{ $item->variations->name }}
                                @endif
                            </td>

                            <td>
                                <span class="display_currency" data-is_quantity="true"
                                    data-currency_symbol="false">{{ $item->quantity }}</span>
                                @if (!empty($item->sub_unit))
                                    {{ $item->sub_unit->short_name }}
                                @else
                                    {{ $item->product->unit->short_name }}
                                @endif

                                @if (!empty($item->product->second_unit) && $item->secondary_unit_quantity != 0)
                                    <br>
                                    <span class="display_currency" data-is_quantity="true"
                                        data-currency_symbol="false">{{ $item->secondary_unit_quantity }}</span>
                                    {{ $item->product->second_unit->short_name }}
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </table>
            </div>
        </div>
    </div>
    <br>


    {{-- Barcode --}}
    @if ($order->ref_no !== null)
    <div class="row print_section">
        <div class="col-xs-12">
            <img class="center-block"
                src="data:image/png;base64,{{ DNS1D::getBarcodePNG($order->ref_no, 'C128', 2, 30, [39, 48, 54], true) }}">
        </div>
    </div> 
    @endif
    
</div>
