@extends('layouts.app')
@section('title', __('lang_v1.edit_order'))

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>@lang('lang_v1.edit_order') <i class="fa fa-keyboard-o hover-q text-muted" aria-hidden="true" data-container="body"
                data-toggle="popover" data-placement="bottom" data-content="@include('purchase.partials.keyboard_shortcuts_details')" data-html="true"
                data-trigger="hover" data-original-title="" title=""></i></h1>
    </section>

    <!-- Main content -->
    <section class="content">

        @include('layouts.partials.error')

        {!! Form::open([
            'url' => action([\App\Http\Controllers\OrderController::class, 'update'], [$order->id]),
            'method' => 'PUT',
            'id' => 'add_order_form',
            'files' => false,
        ]) !!}
        <input type="hidden" name="location_id" id="location_id"
            value="{{ request()->session()->get('user.business_id') }}">
        @component('components.widget', ['class' => 'box-primary'])
            <div class="row">
                <div class="@if (!empty($default_purchase_status)) col-sm-4 @else col-sm-3 @endif">
                    <div class="form-group">
                        {!! Form::label('supplier_id', __('purchase.supplier') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-user"></i>
                            </span>
                            {!! Form::select('contact_id', [$order->contact_id => $order->contact->name], $order->contact_id, [
                                'class' => 'form-control',
                                'placeholder' => __('messages.please_select'),
                                'required',
                                'id' => 'supplier_id',
                            ]) !!}
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-default bg-white btn-flat add_new_supplier"
                                    data-name=""><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
                            </span>
                        </div>
                    </div>
                </div>

            </div>
            <br />
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-search"></i>
                            </span>
                            {!! Form::text('search_product', null, [
                                'class' => 'form-control mousetrap',
                                'id' => 'search_product',
                                'placeholder' => __('lang_v1.search_product_placeholder'),
                                'disabled' => false,
                            ]) !!}
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-condensed table-bordered table-th-green text-center table-striped"
                            id="order_entry_table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>@lang('sale.product')</th>
                                    <th>@lang('sale.qty')</th>
                                    <th><i class="fa fa-trash" aria-hidden="true"></i></th>
                                </tr>
                            </thead>
                            <tbody id="orders-lists">
                                @foreach ($order->items as $key => $item)
                                    @include('order.partials.order_entry_row', [
                                        'item' => $item,
                                        'product' => $item->product,
                                        'variations' => $item->product->variations,
                                        'row_count' => $key,
                                    ])
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <input type="hidden" id="row_count" value="{{ $order->items->count() }}">
        @endcomponent

        @component('components.widget', ['class' => 'box-primary'])
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('additional_notes', __('purchase.additional_notes')) !!}
                        {!! Form::textarea('additional_notes', $order->additional_notes, ['class' => 'form-control', 'rows' => 3]) !!}
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <button type="button" id="submit_order_form"
                        class="btn btn-primary pull-right btn-flat">@lang('messages.update')</button>
                </div>
            </div>
        @endcomponent

        {!! Form::close() !!}
    </section>

    <div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>

    <div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        @include('contact.create', ['quick_add' => true])
    </div>
    @include('purchase.partials.import_purchase_products_modal')
    <!-- /.content -->
@endsection

@section('javascript')
    <script src="{{ asset('js/order.js?v=' . $asset_v) }}"></script>
@endsection
