<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!--Bootstrap CSS only -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-0evHe/X+R7YkIZDRvuzKMRqM+OrBnVFBL6DOitfPri4tjfHxaWutUpFmBp4vmVor" crossorigin="anonymous">
    <link rel="stylesheet" href="{{ mix('css/login.css') }}">
    <link href="https://fonts.googleapis.com/css?family=Material+Icons|Material+Icons+Outlined|Material+Icons+Two+Tone|Material+Icons+Round|Material+Icons+Sharp" rel="stylesheet">

    <title>@yield('title', 'Login') - {{ config('app.name') }}</title>
</head>

<body style="background-image: url('img/login-background.jpg')">

    <!-- *---------------------------------Login------------------* -->
    <div class="main-body">
        <div class="row  justify-content-md-center">
            
            <div class="col-md-6 col-lg-5 col-xl-4 col-12 col-sm-9 mx-auto py-5">
                <div class="sign-form">
                    <div class="sign-info">
                        <h2 style="margin-bottom:0px">@lang('lang_v1.login')</h2>
                    </div>
                    @php
                        $username = old('username');
                        $password = null;
                        if (config('app.env') == 'demo') {
                            $username = 'admin';
                            $password = '12345678';
                        
                            $demo_types = [
                                'all_in_one' => 'admin',
                                'super_market' => 'admin',
                                'pharmacy' => 'admin-pharmacy',
                                'electronics' => 'admin-electronics',
                                'services' => 'admin-services',
                                'restaurant' => 'admin-restaurant',
                                'superadmin' => 'superadmin',
                                'woocommerce' => 'woocommerce_user',
                                'essentials' => 'admin-essentials',
                                'manufacturing' => 'manufacturer-demo',
                            ];
                        
                            if (!empty($_GET['demo_type']) && array_key_exists($_GET['demo_type'], $demo_types)) {
                                $username = $demo_types[$_GET['demo_type']];
                            }
                        }
                    @endphp

                    <form class="form" method="POST" action="{{ route('login') }}" id="login-form">
                        {{ csrf_field() }}
                        <div @class(['input-field form-group has-feedback', 'has-error' => $errors->has('username')])>
                            <label for="username">User name</label>
                            <input type="text" id="username" class="form-control" name="username" value="{{ $username }}" required autofocus>
                            
                            @error('username')
                                <span class="help-block">
                                    <p class="text-danger">{{ $message }}</p>
                                </span>
                            @enderror
                        </div>
                        <div @class(['input-field form-group has-feedback', 'has-error' => $errors->has('password')])>
                            <label for="password">Password</label>
                            <input id="password" type="password" class="form-control" name="password" value="{{ $password }}" required>
                            
                            @error('password')
                                <span class="help-block">
                                    <p class="text-danger">{{ $message }}</p>
                                </span>
                            @enderror
                        </div>
                        <div class="checkbox-field justify-content-between">
                            <span class="d-flex align-items-baseline pb-2">
                                <input type="checkbox" name="remember" id="remember" @checked(old('remember'))>
                                <p style="margin-left:5px"><label for="remember">@lang('lang_v1.remember_me')</label></p>
                            </span>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="submit-button">@lang('lang_v1.login')</button>
                            @if (config('app.env') != 'demo')
                                <a href="{{ route('password.request') }}" class="pull-right">
                                    @lang('lang_v1.forgot_your_password')
                                </a>
                            @endif
                        </div>
                    </form>

                    <div class="signup-footer my-5">
                        <img src="{{ asset('img/purobi.png') }}" style="width:60%" alt="">
                    </div>

                    <div style="text-align: left;">
                        <select class="form-control input-sm" id="change_lang" style="margin: 10px;">
                            @foreach(config('constants.langs') as $key => $val)
                                <option value="{{$key}}" 
                                    @if( (empty(request()->lang) && config('app.locale') == $key) 
                                    || request()->lang == $key) 
                                        selected 
                                    @endif
                                >
                                    {{$val['full_name']}}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @include('layouts.partials.javascripts')
    
    <!-- Scripts -->
    <script src="{{ asset('js/login.js?v=' . $asset_v) }}"></script>

    <script>
        $(function(){
            $(document).on('change', '#change_lang', function(){
                window.location = "{{ route('login') }}?lang=" + $(this).val();
            });
    
            $('a.demo-login').click( function (e) {
               e.preventDefault();
               $('#username').val($(this).data('admin'));
               $('#password').val("{{$password}}");
               $('form#login-form').submit();
            });
        });
    </script>
</body>

</html>
