<?php

use App\ProductDue;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_dues', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('contact_id');
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->integer('quantity');
            $table->enum('type', [ProductDue::COLLECTION,ProductDue::DUE])->default(ProductDue::DUE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_dues');
    }
};
