<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductDue extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    const COLLECTION = 'Collection', DUE = 'Due';

    /**
     * Return list of contact dropdown for a business
     */
    public static function forDropdown()
    {
        return ['Collection' => '(+)' . __('lang_v1.collection'), 'Due' => '(-)' . __('lang_v1.due')];
    }

    /**
     * Get the contact that owns the Product Due
     */
    public function contact()
    {
        return $this->belongsTo(Contact::class);
    }

    /**
     * Get the product that owns the Product Due
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
